
DECLARE @teamAssignmentCount int
DECLARE @modelPatientSid int
DECLARE @newPatientSid int

DECLARE @PatientTeamAssignmentSID int

DECLARE @teamAssignmentCsr cursor
DECLARE @newPatientsCsr cursor

set @modelPatientSid = 3504586

SET @teamAssignmentCsr = CURSOR FOR
  SELECT PatientTeamAssignmentSID FROM CDWWork.PCMM.PatientTeamAssignment
  WHERE PatientSID = @modelPatientSid
    and PatientTeamEndDate IS NULL
    and Sta3n = 523

SET @newPatientsCsr = CURSOR FOR
  SELECT PatientSID FROM CDWWork.Patient.Patient
  WHERE PatientSID > (select max(PatientSID) -25 from CDWWork.Patient.Patient)

OPEN @newPatientsCsr
FETCH NEXT FROM @newPatientsCsr INTO @newPatientSid
WHILE (@@FETCH_STATUS = 0)
BEGIN
  print @newPatientSid

  OPEN @teamAssignmentCsr
  FETCH NEXT FROM @teamAssignmentCsr INTO @PatientTeamAssignmentSID

  WHILE (@@FETCH_STATUS = 0)
  BEGIN
    print concat('    ', @PatientTeamAssignmentSID)

    insert into CDWWork.PCMM.PatientTeamAssignment
      select
        (select max(PatientTeamAssignmentSID) + 1 from CDWWork.PCMM.PatientTeamAssignment),
        PatientTeamAssignmentIEN,
        Sta3n,
        @newPatientSid,
        TeamSID,
        Team,
        PatientTeamStartDate,
        PatientTeamEndDate,
        PatientTeamAssignmentType,
        PatientTeamAssignmentStatus,
        RestrictConsultsFlag,
        EnteredDateTime,
        EnteredByStaffSID,
        LastEditedDateTime,
        LastEditedByStaffSID,
        ETLBatchID,
        VistaCreateDate,
        VistaEditDate
      from CDWWork.PCMM.PatientTeamAssignment
      where PatientTeamAssignmentSID = @PatientTeamAssignmentSID

    FETCH NEXT FROM @teamAssignmentCsr INTO @PatientTeamAssignmentSID
  END

  CLOSE @teamAssignmentCsr
  FETCH NEXT FROM @newPatientsCsr INTO @newPatientSid
END


DEALLOCATE @teamAssignmentCsr
DEALLOCATE @newPatientsCsr
